/**
 * URM – Main Router Menu
 * 
 * This script registers the main admin menu for the User Role Membership plugin.
 * It handles tab rendering, navigation, and routing to individual module views.
 * Tabs: Dashboard, Process Log, User List, Instructions
 *
 * Author: Black & Copilot
 */

// // 🔧 URM – Main router menu

function create_ur_membership_menu() {
    add_menu_page(
        'User Role Membership',           // Page title
        'UR Membership',                  // Name in the sidebar (shortend to fit the sidebar without wrapping)
        'manage_options',                 // Access rights
        'ur-membership',                  // Slug
        'render_ur_membership_page',      // Callback function to render content
        'dashicons-admin-users',          // Icon
        6                                 // Position in the menu
    );
}
add_action('admin_menu', 'create_ur_membership_menu');

function render_ur_membership_page() {
	urm_guard_router_integrity();
	
    $active_tab = $_GET['tab'] ?? 'dashboard';

    echo '<div class="wrap">';
    echo '<h1 style="margin-bottom: 20px;">User Role Membership</h1>';

    // 🧭 Tabs with icons
    $tabs = [
        'dashboard' => ['label' => 'Control panel', 'icon' => '⚙️'],
        'log'       => ['label' => 'Process monitoring', 'icon' => '📊'],
        'users'     => ['label' => 'User list', 'icon' => '👥'],
        'help'      => ['label' => 'Instructions', 'icon' => '📋']
    ];

    // 🔷 Tab navigation
    echo '<div style="display: flex; gap: 0px; margin-bottom: 0;">';

    foreach ($tabs as $slug => $tab) {
        $is_active = ($active_tab === $slug);
        $style = 'padding: 10px 16px; border-radius: 8px 8px 0 0; text-decoration: none; background: ' . ($is_active ? '#f9f9f9' : '#e4e4e4') . '; color: black; border: 1px solid #ccc; border-bottom: none; outline: none; box-shadow: none;';

        echo '<a href="?page=ur-membership&tab=' . $slug . '" style="' . $style . '">';
        echo '<span style="margin-right: 6px;">' . $tab['icon'] . '</span>' . esc_html($tab['label']);
        echo '</a>';
    }

    echo '</div>';

    // ⬇️ Visual tab support bar - creates the ilusion of tabs ancored in the panel
    echo '<div style="height: 0px; background: #ccc; margin-top: -1px;"></div>';

    // 📦 Content container styled for clarity and separation
    echo '<div style="background: #f9f9f9; border: 1px solid #ccc; border-radius: 0 8px 8px 8px; padding: 20px; margin-bottom: 30px;">';

    switch ($active_tab) {
        case 'log':
            render_ur_process_log_tab();
            break;
        case 'users':
            render_ur_user_list_tab();
            break;
        case 'help':
            render_ur_help_tab();
            break;
        case 'dashboard':
        default:
            render_ur_dashboard_tab();
            break;
    }

// ➕ Plugin footer signature
echo '<div style="text-align: center; margin-top: 40px; font-size: 14px; color: #999;">';
echo '<i>Made with 💖 User Role Membership 3.0</i>';
echo '</div>';

// Close the main .wrap div
echo '</div>';

}
